<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Order extends Model
{
    use HasFactory, HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'sale_date',
        'order_snap',
        'fuel_charges',
        'other_charges',
        'other_charges_detail',
        'sub_total',
        'total',
    ];

    protected $casts = [
        'order_snap' => 'array',
        'sale_date' => 'date',
    ];

       protected static function booted()
    {
        static::creating(function ($model) {
            $model->updated_at = null;
        });

        static::updating(function ($model) {
            $model->updated_at = now();
        });
    }

    /**
     * Relationship: One Order has many OrderDetails
     */
    public function details()
    {
        return $this->hasMany(OrderDetail::class, 'order_id', 'id');
    }
}
