<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class PackSize extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'name',
        'quantity',
        'description',
    ];

    protected static function booted(): void
    {
        static::creating(function (self $model): void {
            $model->updated_at = null;
        });

        static::updating(function (self $model): void {
            $model->updated_at = now();
        });
    }
}
