<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        
        // calling role permission seeder
        $this->call([
            RolePermissionSeeder::class,
        ]);
 
        // creating admin user
        $admin = User::create([
            'name' => 'Admin',
            'email' => 'admin@admin.com',
            'password' => Hash::make('password'),
        ]);
        $admin->assignRole('admin');
    
        // creating cashier user
        $cashier = User::create([
            'name' => 'Cashier',
            'email' => 'cashier@cashier.com',
            'password' => Hash::make('password'),
        ]);
        $cashier->assignRole('cashier');
    
        // creating sub-admin user
        $subAdmin = User::create([
            'name' => 'Sub-Admin',
            'email' => 'sub-admin@sub-admin.com',
            'password' => Hash::make('password'),
        ]);
        $subAdmin->assignRole('sub-admin');

        // Seed test data (products, stock, sales)
        // Comment out the line below if you don't want test data
        $this->call([
            TestDataSeeder::class,
        ]);
    }
}
