<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // deleting all permissions and roles
        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('role_has_permissions')->truncate();
        DB::table('model_has_permissions')->truncate();
        DB::table('model_has_roles')->truncate();
        DB::table('permissions')->truncate();
        DB::table('roles')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');


        // creating permissions
        $permissions = [
            'view-dashboard',
            'view-pos',
            'view-product',
            'view-pack-sizes',
            'view-inventory',
            'view-stockin',
            'view-stockout',
            'view-sales',
            'view-accounting',
            'view-users',
            'view-roles',
            'view-permissions',
        ];
        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // creating roles
        $roles = [
            'admin',
            'cashier',
            'sub-admin',
        ];
        foreach ($roles as $role) {
            Role::create(['name' => $role]);
        }

        // assigning permissions to roles
        $adminRole = Role::where('name', 'admin')->first();
        $adminRole->givePermissionTo(Permission::all());

        $cashierRole = Role::where('name', 'cashier')->first();
        $cashierRole->givePermissionTo([
            'view-dashboard',
            'view-pos',
            'view-sales',
        ]);

        $userRole = Role::where('name', 'sub-admin')->first();
        $userRole->givePermissionTo([
            'view-dashboard',
            'view-product',
            'view-pack-sizes',
            'view-inventory',
            'view-stockin',
            'view-stockout',
            'view-sales',
            'view-accounting',
        ]);
    }
}
