<!-- Edit Stock Out Modal -->
<div class="modal fade" id="editStockOutModal{{ $inventory->id }}" tabindex="-1" aria-labelledby="editStockOutLabel{{ $inventory->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ url('update-stock-out/'.$inventory->id) }}" method="POST" class="needs-validation" novalidate>
                @csrf
                @method('PUT')
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title" id="editStockOutLabel{{ $inventory->id }}">Edit Stock Out</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <!-- Product Dropdown (readonly) -->
                    <div class="mb-3">
                        <label>Select Product</label>
                        <select name="product_id" class="form-select" disabled>
                            <option value="{{ $inventory->product_id }}">{{ $inventory->product->name ?? '-' }}</option>
                        </select>
                    </div>

                    <!-- Quantity -->
                    <div class="mb-3">
                        <label>Quantity</label>
                        <input type="number" name="quantity" class="form-control" value="{{ $inventory->quantity }}" required>
                    </div>

                    <!-- Sale Date -->
                    <div class="mb-3">
                        <label for="saleDate{{ $inventory->id }}" class="form-label">Stock Out Date</label>
                        <input type="text" id="saleDate{{ $inventory->id }}" name="sale_date" class="form-control" value="{{ \Carbon\Carbon::parse($inventory->stock_out_date)->format('d/m/Y') }}" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-warning text-white">Update</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    flatpickr("#saleDate{{ $inventory->id }}", {
        dateFormat: "d/m/Y",
        defaultDate: "{{ \Carbon\Carbon::parse($inventory->stock_out_date)->format('d/m/Y') }}",
        allowInput: true
    });
});
</script>
