<div class="modal fade" id="editProductModal{{ $product->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ url('update-product/'.$product->id) }}" method="POST" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title">Edit Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <!-- Name -->
                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name" value="{{ $product->name }}" class="form-control" required>
                    </div>

                    <!-- Image -->
                    <div class="mb-3">
                        <label>Product Image</label>
                        @if($product->image)
                            <div class="mb-2">
                                <img src="{{ asset('storage/products/' . $product->image) }}" alt="{{ $product->name }}" class="img-thumbnail" style="max-height: 100px;">
                                <small class="d-block text-muted">Current image</small>
                            </div>
                        @endif
                        <input type="file" name="image" class="form-control" accept="image/*">
                        <small class="text-muted">Leave empty to keep current image</small>
                    </div>

                    <div class="mb-3">
                        <label>Pack Size</label>
                        <select name="pack_size_id" class="form-select" required>
                            <option value="">Select Pack Size</option>
                            @foreach($packSizes as $packSize)
                                <option value="{{ $packSize->id }}" {{ $product->pack_size_id === $packSize->id ? 'selected' : '' }}>
                                    {{ $packSize->name }} ({{ $packSize->quantity }} bottles)
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Description -->
                    {{-- <div class="mb-3">
                        <label>Description</label>
                        <textarea name="description" class="form-control" rows="2">{{ $product->description }}</textarea>
                    </div> --}}

                    <!-- Purchase Price -->
                    {{-- <div class="mb-3">
                        <label>Purchase Price</label>
                        <input type="number" name="purchase_price" value="{{ $product->purchase_price }}" class="form-control" step="0.01" required>
                    </div> --}}

                    <!-- Selling Price -->
                    {{-- <div class="mb-3">
                        <label>Selling Price</label>
                        <input type="number" name="selling_price" value="{{ $product->selling_price }}" class="form-control" step="0.01" required>
                    </div> --}}

                    <!-- Status -->
                    <div class="mb-3">
                        <label>Status</label>
                        <select name="status" class="form-select">
                            <option value="1" {{ $product->status ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ !$product->status ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update</button>
                </div>

            </form>
        </div>
    </div>
</div>
