@extends('layouts.app')

@section('content')
<style>
    .stat-card {
        border-radius: 0.5rem;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        min-height: 160px;
        display: flex;
        flex-direction: column;
    }
    .stat-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
    .stat-card .card-body {
        flex: 1;
        display: flex;
        flex-direction: column;
    }
    .stat-card-icon {
        font-size: 2.5rem;
        opacity: 0.3;
        flex-shrink: 0;
    }
    .growth-indicator {
        font-size: 0.875rem;
        font-weight: 600;
    }
    .growth-positive {
        color: #20c997;
    }
    .growth-negative {
        color: #dc3545;
    }
    .stat-card h3 {
        min-height: 2.5rem;
        display: flex;
        align-items: center;
    }
    .stat-card small {
        min-height: 1.25rem;
        display: block;
    }
</style>
<div class="content">
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-0">Dashboard</h1>
                <p class="text-secondary mb-0">Welcome back! Here's what's happening with your business.</p>
            </div>
            <div class="text-end">
                <small class="text-secondary">{{ \Carbon\Carbon::now()->format('l, F j, Y') }}</small>
            </div>
        </div>

        <!-- Key Metrics Cards -->
        <div class="row g-3 mb-4">
            <!-- Today's Sales -->
            <div class="col-6 col-lg-3">
                <div class="card stat-card text-bg-primary text-white h-100">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between align-items-start mb-auto">
                            <div class="flex-grow-1">
                                <h6 class="text-white-50 mb-2">Today's Sales</h6>
                                <h3 class="mb-2">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($todaySales, 2) }}</h3>
                                <small class="text-white-50 d-block">{{ $todayOrders }} order(s)</small>
                            </div>
                            <i class="bi bi-cash-coin stat-card-icon"></i>
                        </div>
                    </div>
                    <div class="card-footer bg-primary bg-opacity-50 border-0">
                        <small><i class="bi bi-calendar3 me-1"></i>Today</small>
                    </div>
                </div>
            </div>

            <!-- Month Sales -->
            <div class="col-6 col-lg-3">
                <div class="card stat-card text-bg-success text-white h-100">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between align-items-start mb-auto">
                            <div class="flex-grow-1">
                                <h6 class="text-white-50 mb-2">This Month</h6>
                                <h3 class="mb-2">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($monthSales, 2) }}</h3>
                                @if($salesGrowth != 0)
                                    <small class="growth-indicator {{ $salesGrowth > 0 ? 'growth-positive' : 'growth-negative' }} d-block">
                                        <i class="bi bi-arrow-{{ $salesGrowth > 0 ? 'up' : 'down' }} me-1"></i>{{ abs($salesGrowth) }}%
                                    </small>
                                @else
                                    <small class="text-white-50 d-block" style="visibility: hidden;">—</small>
                                @endif
                            </div>
                            <i class="bi bi-graph-up-arrow stat-card-icon"></i>
                        </div>
                    </div>
                    <div class="card-footer bg-success bg-opacity-50 border-0">
                        <small><i class="bi bi-calendar-month me-1"></i>{{ \Carbon\Carbon::now()->format('F Y') }}</small>
                    </div>
                </div>
            </div>
            
            <!-- Total Orders -->
            <div class="col-6 col-lg-3">
                <div class="card stat-card text-bg-info text-white h-100">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between align-items-start mb-auto">
                            <div class="flex-grow-1">
                                <h6 class="text-white-50 mb-2">Total Orders</h6>
                                <h3 class="mb-2">{{ number_format($totalOrders) }}</h3>
                                <small class="text-white-50 d-block">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($averageOrderValue, 2) }} avg</small>
                            </div>
                            <i class="bi bi-receipt-cutoff stat-card-icon"></i>
                        </div>
                    </div>
                    <div class="card-footer bg-info bg-opacity-50 border-0">
                        <small><i class="bi bi-bag-check me-1"></i>All Time</small>
                    </div>
                </div>
            </div>

            <!-- Products -->
            <div class="col-6 col-lg-3">
                <div class="card stat-card text-bg-warning text-white h-100">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between align-items-start mb-auto">
                            <div class="flex-grow-1">
                                <h6 class="text-white-50 mb-2">Products</h6>
                                <h3 class="mb-2">{{ number_format($totalProducts) }}</h3>
                                <small class="text-white-50 d-block">{{ $lowStockProducts->count() }} low stock</small>
                            </div>
                            <i class="bi bi-box-seam stat-card-icon"></i>
                        </div>
                    </div>
                    <div class="card-footer bg-warning bg-opacity-50 border-0">
                        <small><i class="bi bi-grid-3x3 me-1"></i>{{ $totalPackSizes }} pack sizes</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Sales Chart -->
            <div class="col-12 col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-body-tertiary d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Sales Overview (Last 30 Days)</h5>
                        <span class="badge text-bg-primary">{{ $monthOrders }} orders</span>
                    </div>
                    <div class="card-body">
                        <div id="salesChart" style="height: 350px;"></div>
                    </div>
                </div>
            </div>

            <!-- Stock Statistics -->
            <div class="col-12 col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-body-tertiary">
                        <h5 class="mb-0">Stock Statistics</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="text-secondary">Total Stock In</span>
                            <strong>{{ number_format($totalStockIn) }}</strong>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="text-secondary">Total Stock Out</span>
                            <strong>{{ number_format($totalStockOut) }}</strong>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="text-secondary">Stock Value</span>
                            <strong class="text-primary">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($totalStockValue, 2) }}</strong>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="fw-semibold">Total Sales</span>
                            <strong class="text-success fs-5">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($totalSales, 2) }}</strong>
                        </div>
                    </div>
                </div>

                <!-- Low Stock Alerts -->
                @if($lowStockProducts->count() > 0)
                <div class="card shadow-sm border-warning">
                    <div class="card-header bg-warning bg-opacity-25">
                        <h5 class="mb-0 text-warning-emphasis">
                            <i class="bi bi-exclamation-triangle me-2"></i>Low Stock Alert
                        </h5>
                    </div>
                    <div class="card-body p-2">
                        <div class="list-group list-group-flush">
                            @foreach($lowStockProducts->take(5) as $product)
                            <div class="list-group-item px-2 py-2 border-0">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong class="small">{{ $product->name }}</strong>
                                        <br>
                                        <small class="text-secondary">{{ $product->packSize->name ?? 'N/A' }}</small>
                                    </div>
                                    <span class="badge text-bg-warning">{{ $product->available_packs }} pack(s)</span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @if($lowStockProducts->count() > 5)
                        <div class="text-center mt-2">
                            <small class="text-secondary">+{{ $lowStockProducts->count() - 5 }} more</small>
                        </div>
                        @endif
                    </div>
                </div>
                @endif
            </div>
        </div>

        <div class="row g-4 mt-2">
            <!-- Recent Sales -->
            <div class="col-12 col-lg-7">
                <div class="card shadow-sm">
                    <div class="card-header bg-body-tertiary d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Recent Sales</h5>
                        <a href="{{ url('sales') }}" class="btn btn-sm btn-outline-primary">View All</a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0 align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">Date</th>
                                        <th scope="col">Order ID</th>
                                        <th scope="col" class="text-end">Total</th>
                                        <th scope="col" class="text-end">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentSales as $sale)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($sale->sale_date)->format('d M Y') }}</td>
                                        <td>
                                            <small class="text-secondary">#{{ substr($sale->id, 0, 8) }}...</small>
                                        </td>
                                        <td class="text-end fw-semibold">{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($sale->total, 2) }}</td>
                                        <td class="text-end">
                                            <a href="{{ url('order-details/' . $sale->id) }}" class="btn btn-sm btn-outline-primary">
                                                View
                                            </a>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-secondary py-4">
                                            <i class="bi bi-inbox me-2"></i>No sales yet
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Products -->
            <div class="col-12 col-lg-5">
                <div class="card shadow-sm">
                    <div class="card-header bg-body-tertiary">
                        <h5 class="mb-0">Top Selling Products (Last 30 Days)</h5>
                    </div>
                    <div class="card-body p-0">
                        @if($topProducts->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($topProducts as $index => $product)
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge text-bg-primary me-3">{{ $index + 1 }}</span>
                                    <div>
                                        <strong class="small">{{ $product['product_name'] }}</strong>
                                        <br>
                                        <small class="text-secondary">{{ $product['total_sold'] }} pack(s) sold</small>
                                    </div>
                                </div>
                                <i class="bi bi-trophy-fill text-warning"></i>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="text-center text-secondary py-4">
                            <i class="bi bi-inbox me-2"></i>No sales data available
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Chart
    const chartData = @json($chartData);
    
    const salesChartOptions = {
        series: [{
            name: 'Sales',
            data: chartData.map(item => item.sales)
        }],
        chart: {
            type: 'area',
            height: 350,
            toolbar: {
                show: false
            },
            zoom: {
                enabled: false
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'smooth',
            width: 2
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.3,
                stops: [0, 90, 100]
            }
        },
        colors: ['#0d6efd'],
        xaxis: {
            categories: chartData.map(item => {
                const date = new Date(item.date);
                return date.toLocaleDateString('en-GB', { day: 'numeric', month: 'short' });
            }),
            labels: {
                style: {
                    fontSize: '12px'
                }
            }
        },
        yaxis: {
            labels: {
                formatter: function(value) {
                    return '{{ env('APP_CURRENCY_SYMBOL') }}' + value.toFixed(0);
                },
                style: {
                    fontSize: '12px'
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(value) {
                    return '{{ env('APP_CURRENCY_SYMBOL') }}' + value.toFixed(2);
                }
            }
        },
        grid: {
            borderColor: '#e9ecef',
            strokeDashArray: 3
        }
    };

    const salesChart = new ApexCharts(document.querySelector("#salesChart"), salesChartOptions);
    salesChart.render();
});
</script>
@endpush
@endsection
