@extends('layouts.app')

@section('content')
<div class="content">
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-0">Add Permission</h1>
                <p class="text-secondary mb-0">Create a new permission for role assignments.</p>
            </div>
            <a href="{{ route('permissions.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Permissions
            </a>
        </div>

        <div class="card shadow-sm">
            <div class="card-body">
                <form action="{{ route('permissions.store') }}" method="POST" class="row g-4">
                    @csrf

                    <div class="col-12 col-md-6">
                        <label for="name" class="form-label">Permission Name</label>
                        <input
                            type="text"
                            name="name"
                            id="name"
                            class="form-control @error('name') is-invalid @enderror"
                            value="{{ old('name') }}"
                            required
                            placeholder="e.g. manage orders"
                        >
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Note:</strong> After creating a permission, you may need to add it to the routes/middleware and ui components in the codebase for it to take effect. Permissions created here won't automatically reflect unless they are configured in the application code.
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Create Permission
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

