@extends('layouts.app')

@section('title', 'Profile')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
          @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

            <!-- Profile Card -->
            <div class="card shadow-sm rounded-3">
                <div class="card-header bg-light text-center">
                    <h2 class="mb-0">My Profile</h2>
                </div>
                <div class="card-body row">

                    <!-- Profile Info -->
                   <div class="col-md-4 text-center mb-4 mb-md-0">
                        <div class="position-relative mx-auto" style="width: 150px; height: 150px;">
                            @php
                                $photo = auth()->user()->profile_photo;
                                $photoUrl = $photo && \Illuminate\Support\Facades\Storage::disk('public')->exists($photo)
                                    ? asset('storage/' . $photo) . '?v=' . (auth()->user()->updated_at ? auth()->user()->updated_at->timestamp : time())
                                    : asset('img/user2-160x160.jpg');
                            @endphp

                            <img 
                                id="profile-image-preview"
                                src="{{ $photoUrl }}" 
                                class="rounded-circle w-100 h-100 border border-secondary shadow-sm object-fit-cover" 
                                alt="Profile Photo"
                                style="cursor: pointer;"
                                onclick="document.getElementById('profile-photo-input').click();"
                                title="Click to change profile photo">
                            
                            <!-- Overlay icon on hover -->
                            <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center rounded-circle" 
                                 style="background-color: rgba(0,0,0,0.5); opacity: 0; transition: opacity 0.3s; pointer-events: none;"
                                 id="profile-image-overlay">
                                <i class="bi bi-camera-fill text-white fs-3"></i>
                            </div>
                        </div>
                        <h4 class="mt-3">{{ auth()->user()->name }}</h4>
                        <p class="text-muted">{{ auth()->user()->email }}</p>
                        <p class="text-muted small">Click on photo to update</p>
                    </div>

                    <!-- Forms -->
                    <div class="col-md-8">

                        <!-- Update Profile Form -->
                        <div class="card mb-4 shadow-sm rounded-3">
                            <div class="card-header bg-white">
                                <h5 class="mb-0">Update Profile</h5>
                            </div>
                            <div class="card-body">
                                <form action="{{ url('update-profile') }}" method="POST" enctype="multipart/form-data" id="profile-update-form">
                                    @csrf
                                    @method('PUT')
                                    
                                    <!-- Hidden file input -->
                                    <input 
                                        type="file" 
                                        id="profile-photo-input" 
                                        name="profile_photo" 
                                        accept="image/*" 
                                        style="display: none;"
                                        onchange="handleProfilePhotoChange(event)">

                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" name="name" value="{{ old('name', auth()->user()->name) }}" class="form-control @error('name') is-invalid @enderror">
                                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" name="email" value="{{ old('email', auth()->user()->email) }}" class="form-control @error('email') is-invalid @enderror">
                                        @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    @error('profile_photo') 
                                        <div class="alert alert-danger">{{ $message }}</div> 
                                    @enderror

                                    <button type="submit" class="btn btn-primary">Save Profile</button>
                                </form>
                            </div>
                        </div>

                        <!-- Change Password Form -->
                        <div class="card shadow-sm rounded-3">
                            <div class="card-header bg-white">
                                <h5 class="mb-0">Change Password</h5>
                            </div>
                            <div class="card-body">
                                <form action="{{ url('change-profile-password') }}" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <div class="mb-3">
                                        <label class="form-label">Current Password</label>
                                        <input type="password" name="current_password" class="form-control @error('current_password') is-invalid @enderror">
                                        @error('current_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">New Password</label>
                                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror">
                                        @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Confirm New Password</label>
                                        <input type="password" name="password_confirmation" class="form-control">
                                    </div>

                                    <button type="submit" class="btn btn-dark">Change Password</button>
                                </form>
                            </div>
                        </div>

                    </div> <!-- End Forms Column -->

                </div> <!-- End Card Body -->
            </div> <!-- End Profile Card -->

        </div>
    </div>
</div>

@push('scripts')
<script>
    // Handle profile photo change with preview
    function handleProfilePhotoChange(event) {
        const file = event.target.files[0];
        if (file) {
            // Validate file type
            if (!file.type.startsWith('image/')) {
                alert('Please select an image file.');
                event.target.value = '';
                return;
            }
            
            // Validate file size (2MB)
            if (file.size > 2048 * 1024) {
                alert('Image size should be less than 2MB.');
                event.target.value = '';
                return;
            }
            
            // Show preview
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('profile-image-preview').src = e.target.result;
            };
            reader.readAsDataURL(file);
            
            // Auto-submit form when image is selected
            const form = document.getElementById('profile-update-form');
            if (form) {
                // Show loading state
                const submitBtn = form.querySelector('button[type="submit"]');
                
                if (submitBtn) {
                    const originalText = submitBtn.innerHTML;
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Uploading...';
                }
                
                // Submit the form normally - page will reload after redirect
                form.submit();
            }
        }
    }
    
    // Show overlay on hover
    const profileImage = document.getElementById('profile-image-preview');
    const overlay = document.getElementById('profile-image-overlay');
    
    if (profileImage && overlay) {
        profileImage.addEventListener('mouseenter', function() {
            overlay.style.opacity = '1';
        });
        
        profileImage.addEventListener('mouseleave', function() {
            overlay.style.opacity = '0';
        });
    }
</script>
@endpush
@endsection
