@extends('layouts.app')

@section('content')
<div class="content">
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-0">Add Role</h1>
                <p class="text-secondary mb-0">Define a new role and assign permissions.</p>
            </div>
            <a href="{{ route('roles.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Roles
            </a>
        </div>

        <div class="card shadow-sm">
            <div class="card-body">
                <form action="{{ route('roles.store') }}" method="POST" class="row g-4">
                    @csrf

                    <div class="col-12 col-md-6">
                        <label for="name" class="form-label">Role Name</label>
                        <input
                            type="text"
                            name="name"
                            id="name"
                            class="form-control @error('name') is-invalid @enderror"
                            value="{{ old('name') }}"
                            required
                            placeholder="e.g. manager"
                        >
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <label for="permissions" class="form-label">Permissions</label>
                        <select
                            name="permissions[]"
                            id="permissions"
                            class="form-select @error('permissions') is-invalid @enderror"
                            multiple
                            size="8"
                        >
                            @foreach ($permissions as $permission)
                                <option value="{{ $permission->name }}" @selected(collect(old('permissions', []))->contains($permission->name))>
                                    {{ ucfirst($permission->name) }}
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">Hold Ctrl (Cmd on Mac) to select multiple permissions.</div>
                        @error('permissions')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Create Role
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

