<?php

use App\Http\Controllers\ProductController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\PosController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PackSizeController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AccountingController;
use Illuminate\Support\Facades\Route;

Auth::routes();

Route::middleware('auth')->group(function () {
    Route::get('/', fn () => redirect()->route('dashboard'))->name('home');

    // Dashboard
    Route::middleware('permission:view-dashboard')->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    });

Route::middleware(['auth'])->group(function () {
    Route::get('edit-profile', [ProfileController::class, 'show']);
    Route::put('update-profile', [ProfileController::class, 'update']);
    Route::put('change-profile-password', [ProfileController::class, 'updatePassword']);
});

    // Products
    Route::middleware('permission:view-product')->group(function () {
        Route::get('products', [ProductController::class, 'index']);
        Route::post('store-product', [ProductController::class, 'store']);
        Route::put('update-product/{id}', [ProductController::class, 'update']);
        Route::delete('delete-product/{id}', [ProductController::class, 'destroy']);
    });

    // Inventory
    Route::middleware('permission:view-inventory')->group(function () {
        Route::get('inventory', [InventoryController::class, 'inventory']);
        Route::get('create-inventory', [InventoryController::class, 'create']);
        Route::put('update-inventory/{id}', [InventoryController::class, 'update']);
        Route::delete('delete-inventory/{id}', [InventoryController::class, 'destroy']);
    });

    // Stock In
    Route::middleware('permission:view-stockin')->group(function () {
        Route::post('stock-in', [InventoryController::class, 'stockIn']);
        Route::get('stock-in-view', [InventoryController::class, 'stockInView']);
        Route::put('update-stock-in/{id}', [InventoryController::class, 'updateStockIn']);
        Route::delete('delete-stock-in/{id}', [InventoryController::class, 'deleteStockIn']);
    });

    // Stock Out
    Route::middleware('permission:view-stockout')->group(function () {
        Route::post('stock-out', [InventoryController::class, 'stockOut']);
        Route::get('stock-out-view', [InventoryController::class, 'stockOutView']);
        Route::put('update-stock-out/{id}', [InventoryController::class, 'updateStockOut']); 
        Route::delete('delete-stock-out/{id}', [InventoryController::class, 'deleteStockOut']); 
    });

    // Sales
    Route::middleware('permission:view-sales')->group(function () {
        Route::get('sales', [InventoryController::class, 'sales']);
        Route::get('order-details/{order}', [InventoryController::class, 'orderDetails']);
    });

    // Accounting
    Route::middleware('permission:view-accounting')->group(function () {
        Route::get('accounting', [AccountingController::class, 'index'])->name('accounting.index');
    });

    // POS
    Route::middleware('permission:view-pos')->group(function () {
        Route::get('create-pos', [PosController::class, 'create']);
        Route::post('store-pos', [PosController::class, 'store']);
    });

    // Pack Sizes
    Route::middleware('permission:view-pack-sizes')->group(function () {
        Route::get('pack-sizes', [PackSizeController::class, 'index'])->name('pack-sizes.index');
        Route::post('pack-sizes', [PackSizeController::class, 'store'])->name('pack-sizes.store');
        Route::put('pack-sizes/{packSize}', [PackSizeController::class, 'update'])->name('pack-sizes.update');
        Route::delete('pack-sizes/{packSize}', [PackSizeController::class, 'destroy'])->name('pack-sizes.destroy');
    });

    // Users
    Route::middleware('permission:view-users')->group(function () {
        Route::get('users', [UserController::class, 'index'])->name('users.index');
        Route::get('users/create', [UserController::class, 'create'])->name('users.create');
        Route::post('users', [UserController::class, 'store'])->name('users.store');
        Route::put('update-user/{id}', [UserController::class, 'update']);
        Route::delete('delete-user/{id}', [UserController::class, 'destroy']);
    });

    // Roles
    Route::middleware('permission:view-roles')->group(function () {
        Route::get('roles', [RoleController::class, 'index'])->name('roles.index');
        Route::get('roles/create', [RoleController::class, 'create'])->name('roles.create');
        Route::post('roles', [RoleController::class, 'store'])->name('roles.store');
        Route::get('roles/{role}/edit', [RoleController::class, 'edit'])->name('roles.edit');
        Route::patch('roles/{role}', [RoleController::class, 'update'])->name('roles.update');
        Route::post('roles/{role}/permissions/toggle', [RoleController::class, 'togglePermission'])->name('roles.permissions.toggle');
        Route::delete('roles/delete/{role}', [App\Http\Controllers\RoleController::class, 'destroy'])->name('roles.destroy');

    });

    // Permissions
    Route::middleware('permission:view-permissions')->group(function () {
        Route::get('permissions', [PermissionController::class, 'index'])->name('permissions.index');
        Route::get('permissions/create', [PermissionController::class, 'create'])->name('permissions.create');
        Route::post('permissions', [PermissionController::class, 'store'])->name('permissions.store');
    });
});
