<div class="modal fade" id="createProductModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(url('store-product')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Add New Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <!-- Name -->
                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <!-- Image -->
                    <div class="mb-3">
                        <label>Product Image</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                        <small class="text-muted">Recommended: Square image (e.g., 400x400px)</small>
                    </div>

                    <div class="mb-3">
                        <label>Pack Size</label>
                        <select name="pack_size_id" class="form-select" required>
                            <option value="">Select Pack Size</option>
                            <?php $__currentLoopData = $packSizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $packSize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($packSize->id); ?>" <?php echo e(old('pack_size_id') == $packSize->id ? 'selected' : ''); ?>>
                                    <?php echo e($packSize->name); ?> (<?php echo e($packSize->quantity); ?> bottles)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Status -->
                    <div class="mb-3">
                        <label>Status</label>
                        <select name="status" class="form-select">
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Product</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH F:\www\waterPOS\resources\views\Product\create.blade.php ENDPATH**/ ?>