<!-- Edit Stock In Modal -->
<div class="modal fade" id="editStockInModal<?php echo e($inventory->id); ?>" tabindex="-1" aria-labelledby="editStockInLabel<?php echo e($inventory->id); ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(url('update-stock-in/'.$inventory->id)); ?>" method="POST" class="needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title" id="editStockInLabel<?php echo e($inventory->id); ?>">Edit Stock In</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <!-- Product Dropdown (readonly) -->
                    <div class="mb-3">
                        <label>Select Product</label>
                        <select name="product_id" class="form-select" required disabled>
                            <option value="<?php echo e($inventory->product_id); ?>"><?php echo e($inventory->product->name ?? '-'); ?></option>
                        </select>
                    </div>

                    <!-- Quantity -->
                    <div class="mb-3">
                        <label>Quantity</label>
                        <input type="number" name="quantity" class="form-control" value="<?php echo e($inventory->quantity); ?>" required>
                    </div>

                    <!-- Total Price -->
                    <div class="mb-3">
                        <label>Total Price</label>
                        <input type="number" name="total_price" class="form-control" value="<?php echo e($inventory->total_price); ?>" step="0.01" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-warning text-white">Update</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH F:\www\waterPOS\resources\views\Inventory\stock-in-edit.blade.php ENDPATH**/ ?>