<div class="modal fade" id="createInventoryModal" tabindex="-1" aria-labelledby="createInventoryLabel">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(url('stock-out')); ?>" method="POST" class="needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Stock Out</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <!-- Product Dropdown -->
                    <div class="mb-3">
                        <label>Select Product</label>
                        <select name="product_id" id="productSelect" class="form-select" required>
                            <option value="">Select Product</option>

                            <?php $__currentLoopData = App\Models\Product::where('status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $inQty = App\Models\StockIn::where('product_id', $product->id)->sum('quantity');
                                    $outQty = App\Models\StockOut::where('product_id', $product->id)->sum('quantity');
                                    $availableQty = $inQty - $outQty;
                                ?>

                                <option value="<?php echo e($product->id); ?>"
                                        data-available="<?php echo e($availableQty); ?>">
                                    <?php echo e($product->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Available Quantity (hidden input just for internal use) -->
                    <input type="hidden" id="availableQuantity">

                    <!-- Quantity Input with Available Text -->
                    <div class="mb-3">
                        <label>Quantity <small id="availableText" class="text-muted"></small></label>
                        <input type="number" name="quantity" id="quantity"
                            class="form-control" placeholder="Enter Quantity" required>
                    </div>

                    <!-- Date -->
                    <div class="mb-3">
                        <label for="orderDate" class="form-label">Order Date</label>
                        <input type="text" id="orderDate" name="sale_date" class="form-control" placeholder="Select date" autocomplete="off">
                    </div>

                </div>

                <div class="modal-footer">
                    <button class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', () => {

    // Date Picker
    flatpickr("#orderDate", {
        dateFormat: "d/m/Y",
        defaultDate: new Date(),
        allowInput: true
    });

    const productSelect = document.getElementById('productSelect');
    const quantityInput = document.getElementById('quantity');
    const availableQtyField = document.getElementById('availableQuantity');
    const availableText = document.getElementById('availableText');

    // Show available quantity when product changes
    productSelect.addEventListener('change', function () {
        const selected = this.options[this.selectedIndex];
        const availableQty = selected.getAttribute('data-available') || 0;

        availableQtyField.value = availableQty;
        quantityInput.value = "";

        // Show next to label
        availableText.textContent = `(Available: ${availableQty})`;
    });

    // Validate quantity
    quantityInput.addEventListener('input', function () {
        const enteredQty = parseInt(this.value);
        const availableQty = parseInt(availableQtyField.value);

        if (enteredQty > availableQty) {
           alert("⚠️ Available quantity is " + availableQty + ". You cannot enter more than this.");

            this.value = availableQty;
        }
    });

});
</script>
<?php /**PATH F:\www\waterPOS\resources\views/Inventory/stock-out.blade.php ENDPATH**/ ?>