<div class="modal fade" id="editInventoryModal<?php echo e($inventory->id); ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(url('update-inventory/'.$inventory->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title">Edit Inventory</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <!-- Product Dropdown -->
                    <div class="mb-3">
                        <label>Product</label>
                        <select name="product_id" id="productSelect<?php echo e($inventory->id); ?>" class="form-select" required>
                            <option value="">Select Product</option>
                            <?php $__currentLoopData = App\Models\Product::where('status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($product->id); ?>" data-price="<?php echo e($product->purchase_price); ?>"
                                    <?php echo e($inventory->product_id == $product->id ? 'selected' : ''); ?>>
                                    <?php echo e($product->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Total Quantity -->
                    <div class="mb-3">
                        <label>Total Quantity</label>
                        <input type="number" name="total_quantity" id="totalQuantity<?php echo e($inventory->id); ?>"
                            class="form-control" value="<?php echo e($inventory->total_quantity); ?>" required min="0">
                    </div>

                    <!-- Current Stock -->
                    <div class="mb-3">
                        <label>Current Stock</label>
                        <input type="number" name="current_stock" id="currentStock<?php echo e($inventory->id); ?>"
                            class="form-control" value="<?php echo e($inventory->current_stock); ?>" required min="0">
                    </div>

                    <!-- Inventory Price (readonly, live) -->
                    <div class="mb-3">
                        <label>Inventory Price</label>
                        <input type="text" id="inventoryPrice<?php echo e($inventory->id); ?>" class="form-control"
                            value="$<?php echo e(number_format($inventory->inventory_price, 2)); ?>" readonly>
                        <small class="text-muted">Calculated as Purchase Price × Total Quantity</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success">Update Inventory</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript for live calculation -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const productSelect = document.getElementById('productSelect<?php echo e($inventory->id); ?>');
        const totalQuantity = document.getElementById('totalQuantity<?php echo e($inventory->id); ?>');
        const inventoryPrice = document.getElementById('inventoryPrice<?php echo e($inventory->id); ?>');

        function calculateInventoryPrice() {
            const selectedOption = productSelect.options[productSelect.selectedIndex];
            const purchasePrice = parseFloat(selectedOption.dataset.price) || 0;
            const quantity = parseFloat(totalQuantity.value) || 0;
            const total = purchasePrice * quantity;

            inventoryPrice.value = total ? `$${total.toFixed(2)}` : 'Calculated Automatically';
        }

        productSelect.addEventListener('change', calculateInventoryPrice);
        totalQuantity.addEventListener('input', calculateInventoryPrice);
    });
</script>
<?php /**PATH F:\www\waterPOS\resources\views\Inventory\edit.blade.php ENDPATH**/ ?>