<!-- EDIT USER MODAL -->
<div class="modal fade" id="editUserModal<?php echo e($user->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Edit User</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="<?php echo e(url('update-user/'.$user->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="modal-body">

                    <div class="mb-3">
                        <label for="name<?php echo e($user->id); ?>" class="form-label">Username</label>
                        <input type="text" id="name<?php echo e($user->id); ?>" name="name" 
                               class="form-control" value="<?php echo e($user->name); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="email<?php echo e($user->id); ?>" class="form-label">Email</label>
                        <input type="email" id="email<?php echo e($user->id); ?>" name="email" 
                               class="form-control" value="<?php echo e($user->email); ?>" required>
                    </div>
                    <div class="mb-3">
    <label for="role<?php echo e($user->id); ?>" class="form-label">Role</label>
    <select id="role<?php echo e($user->id); ?>" name="role" class="form-select" required>
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($role->id); ?>" <?php echo e($user->hasRole($role->name) ? 'selected' : ''); ?>>
                <?php echo e(ucfirst($role->name)); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


                    <div class="mb-3">
                        <label for="status<?php echo e($user->id); ?>" class="form-label">Status</label>
                        <select id="status<?php echo e($user->id); ?>" name="status" class="form-select">
                            <option value="active" <?php echo e($user->status == 'active' ? 'selected' : ''); ?>>Active</option>
                            <option value="inactive" <?php echo e($user->status == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-1"></i>Update
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
<?php /**PATH F:\www\waterPOS\resources\views/users/edit.blade.php ENDPATH**/ ?>